/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant;

import java.io.File;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.tigris.subversion.svnant.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusUtils;

public class Add
extends SvnCommand {
    private File file = null;
    private Vector filesets = new Vector();
    private boolean failonerror = false;
    private File dir = null;
    private boolean recurse = true;
    private ISVNClientAdapter svnClient;

    public void execute(ISVNClientAdapter iSVNClientAdapter) throws BuildException {
        this.svnClient = iSVNClientAdapter;
        this.validateAttributes();
        this.log("Svn : Putting files and directories under revision control :");
        if (this.file != null) {
            this.svnAddFile(this.file);
        }
        if (this.dir != null) {
            this.svnAddDir(this.dir, this.recurse);
        }
        if (this.filesets.size() > 0) {
            for (int i = 0; i < this.filesets.size(); ++i) {
                FileSet fileSet = (FileSet)this.filesets.elementAt(i);
                this.svnAddFileSet(fileSet);
            }
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.file == null && this.dir == null && this.filesets.size() == 0) {
            throw new BuildException("file, url or fileset must be set");
        }
    }

    private void svnAddFile(File file) throws BuildException {
        if (file.exists()) {
            if (file.isDirectory()) {
                this.log("Directory " + file.getAbsolutePath() + " cannot be added using the file attribute.  " + "Use dir instead.");
            } else {
                try {
                    this.svnClient.addFile(file);
                }
                catch (Exception exception) {
                    throw new BuildException("Can't add file " + file.getAbsolutePath() + " to repository", (Throwable)exception);
                }
            }
        } else {
            String string = "Warning: Could not find file " + file.getAbsolutePath() + " to add to the repository.";
            if (!this.failonerror) {
                this.log(string);
            } else {
                throw new BuildException(string);
            }
        }
    }

    private void svnAddDir(File file, boolean bl) throws BuildException {
        if (file.exists()) {
            if (!file.isDirectory()) {
                this.log("File " + file.getAbsolutePath() + " cannot be added using the dir attribute.  " + "Use file instead.");
            } else {
                try {
                    this.svnClient.addDirectory(file, bl);
                }
                catch (Exception exception) {
                    throw new BuildException("Can't add directory " + file.getAbsolutePath() + " to repository", (Throwable)exception);
                }
            }
        } else {
            String string = "Warning: Could not find directory " + file.getAbsolutePath() + " to add to the repository.";
            if (!this.failonerror) {
                this.log(string);
            } else {
                throw new BuildException(string);
            }
        }
    }

    private void svnAddFileWithDirs(File file, File file2) throws BuildException {
        File file3;
        Stack<File> stack = new Stack<File>();
        try {
            if (SVNStatusUtils.isManaged((ISVNStatus)this.svnClient.getSingleStatus(file))) {
                return;
            }
            for (file3 = file.getParentFile(); file3 != null && !SVNStatusUtils.isManaged((ISVNStatus)this.svnClient.getSingleStatus(file3)) && !file3.equals(file2); file3 = file3.getParentFile()) {
                stack.push(file3);
            }
        }
        catch (SVNClientException sVNClientException) {
            throw new BuildException("Cannot get status of file or directory", (Throwable)sVNClientException);
        }
        while (stack.size() > 0) {
            file3 = (File)stack.pop();
            try {
                this.svnClient.addFile(file3);
            }
            catch (Exception exception) {
                throw new BuildException("Cannot add directory " + file3.getAbsolutePath() + " to repository", (Throwable)exception);
            }
        }
        try {
            this.svnClient.addFile(file);
        }
        catch (Exception exception) {
            throw new BuildException("Can't add file " + file.getAbsolutePath() + " to repository", (Throwable)exception);
        }
    }

    private void svnAddFileSet(FileSet fileSet) throws BuildException {
        File file;
        int n;
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
        File file2 = fileSet.getDir(this.getProject());
        String[] stringArray = directoryScanner.getIncludedFiles();
        String[] stringArray2 = directoryScanner.getIncludedDirectories();
        for (n = 0; n < stringArray2.length; ++n) {
            file = new File(file2, stringArray2[n]);
            this.svnAddFileWithDirs(file, file2);
        }
        for (n = 0; n < stringArray.length; ++n) {
            file = new File(file2, stringArray[n]);
            this.svnAddFileWithDirs(file, file2);
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }
}

